<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style type="text/css">

body {
    font-family: 'Josefin Sans', sans-serif;
    background-color: #F3F6FC !important;
}
/********header-section***********/
.header-section{
    background-color: #0E1649;
    border-top: 5px solid #31DED2;
}
.header-section p{
    color: #ffffff;
    padding: 0;
    margin: 0;
    font-weight: 100;
    float: right;
    margin-right: 70px;
}

.header-section .top-part{
    
padding-top: 25px;
    
padding-bottom: 25px;
}
.header-section .top-part h4{
    color: #FFFFFF;
    margin-top: 30px;
}

.header-section .processing h4{
    color: #31DED2;
    font-size: 20px;
    font-weight: 700;
    margin-top: 17px;
    margin-bottom: -45px;
}

/********header-section ends****/


/********success-alert *******/
.success-alert{}

.success-alert .success{}

.success-alert p{
    color: #2DDDD2;
    font-size: 33px;
    font-weight: 800;
}
/********success-alert ends *******/

/********BASIC INFO SECTION *******/

.BASIC-INFO .information h1{
    color: #FFFFFF;
    font-size: 25px;
    font-weight: 400;
    padding: 10px;
    border-top-right-radius: 30px;
}
.BASIC-INFO .information p{
    font-size: 18px;
    font-weight: normal;
    padding: 0;
    margin: 0;
}
.BASIC-INFO .information h5{
    font-size: 13px;
    font-weight: 400;
    color: #A9ACBE;
    padding: 0px;
    margin-bottom: 3px;
}
.BASIC-INFO .information span{
    height: 1px;
    width: 100%;
    display: inline-block;
    background-color: #d6121200;
    margin: 0;
    padding: 0;
}

.BASIC-INFO .information{
    background-color: #0E1649;
    margin-top: 25px;
    margin-bottom: 50px;
    border-top-right-radius: 40px;
    border-bottom-left-radius: 40px;
    padding-left: 20px;
}
.BASIC-INFO .basic-info{}
.BASIC-INFO .basic-info p{
    font-size: 17px;
    font-weight: 500;
    margin-bottom: 0px;
}
.BASIC-INFO .basic-info span{
    height: 2px;
    width: 100%;
    display: inline-block;
}

.BASIC-INFO .basic-info h6{
    color: #707696;
    font-weight: 100;
    margin-bottom: 0px;
    text-align: right;
    margin-top: 1px;
}
.PERSON{
    width: 165px!important;
    height: 165px!important;
    border-radius: 50%!important;
    margin-top: 30px!important;
}
/********BASIC INFO ENDS *******/

/****verification-details*****/
.verification-details{
    margin-top: 50px;
}
.verification-details .verification{
    background-color: #0E1649;
    color: #090808;
    border-top-right-radius: 40px;
    border-bottom-left-radius: 40px;
    padding-left: 20px;
}
.verification h1{
	color: #FFFFFF;
	font-size: 25px;
	font-weight: 400;
	padding: 10px;
	border-top-right-radius: 30px;
}
.details p{
    font-size: 17px;
    font-weight: 500;
    margin-bottom: 0px;
    margin-left: 80px;
}
.details span{
    height: 2px;
    width: 100%;
    display: inline-block;
}
.details h6{
      color: #707696;
      font-weight: 100;
      margin-bottom: 0px;
      text-align: right;
      margin-top: 1px;
      margin-right: 90px;
      font-size: 17px;
}
.Timeline-details{
        margin-top: 50px;
}
.Timeline-details .TIMELINE{
    background-color: #0E1649;
    color: #FFFFFF;
    border-top-right-radius: 40px;
    border-bottom-left-radius: 40px;
    padding-left: 20px;
}
.TIMELINE h1{
    color: #FFFFFF;
    font-size: 25px;
    font-weight: 400;
    padding: 10px;
    border-top-right-radius: 30px;
}
.Timeline-details .t-details{}
.Timeline-details .t-details h5{
    font-size: 17px;
    font-weight: 500;
    margin-bottom: 20px;
    margin-left: 80px;
}
.Timeline-details .t-details p{
    margin-bottom: 20px;
    margin-left: 80px;
}
.Transaction-details{
    margin-bottom: 50px;
}
.Transaction-details .Transaction{
    background-color: #0E1649;
    color: #090808;
    border-top-right-radius: 40px;
    border-bottom-left-radius: 40px;
    padding-left: 20px;
}
.Transaction h1{
    color: #FFFFFF;
    font-size: 25px;
    font-weight: 400;
    padding: 10px;
    border-top-right-radius: 30px;
}
.tran-details h5{font-size: 17px;
    font-weight: 500;
    margin-bottom: 20px;
    margin-left: 80px;
}
.tran-details p{
    text-align: right;
}
.tran-details .code{
    background-image: url(../image/BACKGROUND.png);
    background-position: center;
    background-size: cover;
    background-repeat: no-repeat;
}

.Transaction-details .coupon{
    background-repeat: no-repeat;
    background-size: cover;
    background-position: center;
    margin-top: 30px;
}
.coupon img{
    padding: 40px;
}
.coupon p{
    font-size: 17px;
    font-weight: 400;
    color: #0E1649;
    margin-bottom: 17px;
}
.coupon h6{
    font-size: 17px;
    font-weight: 700;
    color: #0E1649;
}
.coupon h4{
    font-size: 24px;
    font-weight: 700;
    color: #0E1649;
    margin-bottom: 20px;
}

.Terms-Cons{
    background-color: #0E1649;
    padding: 20px;
}
.Terms-Cons .conditions{}
.Terms-Cons .conditions p{
    color: #FFFFFF;
    font-size: 15px;
    font-weight: 500;
}
.Terms-Cons .conditions span{
    color: #fff;
    font-size: 13px;
}
/*extra laptop/desktop */
 @media (max-width: 1199px){
    .header-section p {
    margin-right: 0px;
    font-size: 13px;
}
}
/*extra laptop/desktop */
/* -large device */
 @media (max-width: 991px){
.PERSON {
    width: 140px!important;
    height: 140px!important;
    border-radius: 50%!important;
    margin-top: 30px!important;
}
}
/* large device */
/* medium device*/
 @media (max-width: 767px){
    .header-section .top-part h4 {
    font-size: 24px;
}
.BASIC-INFO .basic-info p {
    font-size: 15px;
    text-align: left;
}
.BASIC-INFO .basic-info h6 {
    font-size: 15px;
}
.PERSON {
    width: 100px!important;
    height: 100px!important;
    border-radius: 50%!important;
    margin-top: 0px!important;
}
.details p {
    font-size: 15px;
    margin-left: 20px;
}
.details h6 {
    margin-right: 20px;
    font-size: 15px;
}
.Timeline-details .t-details h5 {
    font-size: 15px;
    margin-left: 20px;
}
.Timeline-details .t-details p {
    margin-bottom: 20px;
    margin-left: 5px;
    font-size: 12px;
}
.tran-details h5 {
    font-size: 15px;
    margin-left: 20px;
}
.tran-details p {
    text-align: right;
    font-size: 15px;
}
.coupon h4 {
    font-size: 18px;
    margin-top: 20px;
}
.coupon p {
    font-size: 13px;
    }
    .coupon h6 {
    font-size: 15px;
    margin-bottom: 20px;
}
}
table tr th, table tr td {padding-left: 15px; padding-top: 5px;}

		#watermark {
			position: fixed;
			bottom:   0px;
			left:     0px;
			width:    100%;
			height:   28cm;
			z-index:  -1000;
			opacity: .1;
		}
    </style>
    
   <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">

    <title>{{ $verificationTypes->verification_type }}</title>
</head>

<body>
	<div id="watermark">
		<img src="{{ url('/reports/image/watermark.png') }}" height="100%" width="100%" />
	</div>
    <!-------Top section------->
    <div class="header-section">
        <div style="margin: 0 40px; margin-bottom: 25px;">
            <div class="top-part">
                <div class="row justify-content-center align-items-center">
                    <div class="col-lg-5 col-sm-5 col-4">
                   <!--     <img src="{{ url('/reports/image/LOGO.png') }}" class="img-fluid"> -->
                    </div>
                    <div class="col-lg-7  col-sm-7 col-8" style="margin-left: 30%; text-align: right;">
                        <h4>{{ $verificationTypes->verification_type }} Report</h4>
                        <p style="margin-bottom: 30px;">{{ date('l, F, d Y') }}</p>
                    </div>
                </div>
            </div>
            <div class="processing" style="margin-top: -80px;">
                <div class="row justify-content-center align-items-center">
                    <div class="col-lg-4 col-sm-3 col-3" style="height: 80px; padding-left: 50px;">
                        <img src="{{ url('/reports/image/SUCCESSp.png') }}" alt="success" class="img-fluid" width="85px;" >
                    </div>
                    <div class="col-lg-8 col-sm-8 col-9" style="margin-left: 25%;">
                        <h4>Congratulations, verification complete!</h4>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!------------Top section ends-------->

    <!-----------BASIC INFO SECTION------>
    <div class="BASIC-INFO" style="margin: 0 20px; margin-bottom: -130px;">
        <div class="information">
            <h1>Basic information</h1>
        </div>
        <div class="basic-info" style="margin-top: -30px;">
            <div class="row">
                <div class="col-lg-3 col-3 text-center" style="padding-left: 20px; margin-left: 25px; margin-top: 35px; border: 5px solid #2DDDD2; width: 97px; height: 130px; border-radius: 65px; overflow: hidden;">
                	@if(!empty($employeeDetails->photo))
                        <div style="height: 130px; width: 130px;overflow: hidden;border-radius: 50%;display: flex;justify-content: center;align-items: center;margin:0; padding: 0;">
                            <img src="{{ $employeeDetails->photo }}" style="width: 100%;height: auto;" />
                        </div>
                	@else
                    	<img src="{{ url('/reports/image/PERSON.png') }}" alt="PERSON" class="" style="margin-top: -40px; margin-left: -10px; width: 150px !important;">
                    @endif
                </div>
                <div class="col-lg-8 col-48" style="margin-left: 25%;">
                	<table style="width: 100%; padding-right: 25px;">
                		<thead>
                			<tr>
                				<th>Name</th>
                				<td align="right">{{ $employeeDetails->first_name.' '.$employeeDetails->middle_name.' '.$employeeDetails->last_name }}</td>
                			</tr>
                			<tr>
                				<th>Phone No</th>
                				<td align="right">+91-{{ $employeeDetails->mobile }}</td>
                			</tr>
                			<tr>
                				<th>Address</th>
                				<td align="right">
                					{{ $employeeAddress->address_first }} {{ $employeeAddress->address_second }} {{ $employeeAddress->district }}, {{ $employeeAddress->state }}
                				</td>
                			</tr>
                			<tr>
                				<th>Gender</th>
                				<td align="right">{{ $employeeDetails->gender == 'M' ? 'Male' : 'Female' }}</td>
                			</tr>
                			<tr>
                				<th>Date of Birth</th>
                				<td align="right">{{ date('d M Y', strtotime($employeeDetails->dob)) }}</td>
                			</tr>
                			<tr>
                				<th>ID Number</th>
                				<td align="right">
                					{{ substr_replace($employeeDetails->document_no, str_repeat('X', strlen($employeeDetails->document_no) - 4), 0, strlen($employeeDetails->document_no) - 4) }}
                				</td>
                			</tr>
                		</thead>
                	</table>
                </div>
            </div>
        </div>
    </div>
    <!-----------BASIC INFO SECTION------>

    <!-----------verification details------>
    <div class="verification-details" style="margin: 0 20px;">
        <div class="verification" 
        	style="background-color: <?php
        		if($taskDetails->match_status == '0'){
        			echo 'rgb(26, 87, 45)';
        		} elseif($taskDetails->match_status == '1'){
        			echo 'rgb(251, 193, 8)';
        		} else {
        			echo 'rgb(244, 80, 68)';
        		}
        	?>;"
        >
            <h1>Verification details</h1>
        </div>
        <div class="details" style="margin-top: 30px;">
            <div class="row justify-content-center align-items-center">
            	<div class="col-lg-8 col-48">
                	<table style="width: 100%; padding-right: 15px;">
                		<thead>
                			@foreach($verificationFields as $field)
	                			<tr>
	                				<td width="150">{{ $field->fields_name }}</td>
	                				<td align="left">{{ $field->antecedents_value }}</td>
	                				<td align="right" width="10">
	                					<img src="{{ url('/reports/image/'.$field->match_status.'.png') }}" width="25px">
	                				</td>
	                			</tr>
                			@endforeach
                		</thead>
                	</table>
                </div>
            </div>
        </div>
    </div>
    <!-----------verification details------>

	<!---------terms and conditions------>
	<div class="Terms-Cons" style="margin-top: 40px; margin-bottom: -40px;">
	    <div class="conditions">
	        <div class="row justify-content-center align-items-center">
                <div class="col-lg-12 col-12">
                	<p style="text-align: center;">This is a highly confidential document. By registering for such a service and utilizing the services the you agree to the <a href="https://www.gettruehelp.com/service-agreement/" target="_blank">service agreement </a> and <a href="https://www.gettruehelp.com/terms-of-use/" target="_blank">terms & use.</a></p>
                </div>
	        </div>
	    </div>
	</div>
	<!---------terms and conditions------>
    <div style="margin-top: 40px; margin-bottom: -40px;">
        <div class="conditions">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-12 col-12">
                    <table>
                        <thead>
                            <tr>
                                <th>1. This verification document is a computer generated document and does not require a digital signature</th>
                            </tr>
                            <tr>
                                <th>2. The information in this report may only be used by the client to verify statements made by an individual for purposes such as pre-employment verification, suitability for an alliance, etc. This report isn’t a substitute to any process required by the authorities and is not expected to disregard any law that must be adhered to.</th>
                            </tr>
                            <tr>
                                <th>3. Project91 Advance Technology Solutions Pvt. Ltd. Is not the source of the data gathered and the reports are based on the information made available through various modes as verbal, databases, written or Internet and so forth. Therefore, Project91 Advance Technologies Pvt. Ltd. Cannot ensure the accuracy of the data gathered. The data contained in this report is given “as is” with no guarantees, although each effort is made to guarantee that the report is exact and up to date.</th>
                            </tr>
                            <tr>
                                <th>4. Final verification of an individual’s identity and proper use of this verification report is responsibility fo the client.</th>
                            </tr>
                            <tr>
                                <th>5. It is the client’s responsibility to use the verification reports in a fair manner.</th>
                            </tr>
                            <tr>
                                <th>6. Project91 Advance Technologies Pvt. Ltd. intends to help the client get more transparency into the individual’s identity, antecedents and character based on it’s verification report. However, Project91 Advance Solutions Pvt. Ltd. is not responsible for employment decisions made by the client based on the information presented in this verification report.</th>
                            </tr>
                            <tr>
                                <th>7. Under relevant statutory frameworks including the IT Act 2000, client is advised secure storage of this report to protect the privacy of the individual and destruction of the report as per the client’s internal policy of document maintenance.</th>
                            </tr>
                            <tr>
                                <th>8. Project91 Advance Technologies Pvt. Ltd. conducts criminal court records check through reliable government portal for on-going case details and judgements in all District courts of India.</th>
                            </tr>
                            <tr>
                                <th>9. Based on subscription opted by the customer, the search scope is determined. For ex: if the subscription is for PAN India district courts search, then all the district courts in India are searched and if the subscription is only for a specific state search, then all the courts for the corresponding state based on the address provided are searched.</th>
                            </tr>
                            <tr>
                                <th>10. The display of names of the courts in the report Annexure for the court record search results is restricted to display only the names of the courts that correspond to the district of the provided addresses irrespective of the search scope. This is done to keep the report usable and restrict the number of pages in the report.</th>
                            </tr>
                            <tr>
                                <th>11. Project91 Advance Technologies Pvt. Ltd. is registered with NSDL for online PAN verification. Since the results come via system integration, the screenshot proofs might not be always available.</th>
                            </tr>
                            <tr>
                                <th>12. Project91 Advance Technologies Pvt. Ltd. is a registered Sub-AUA with UIDAI and the Aadhaar verification is done through system integration with the UIDAI database. Therefore, there would be no screenshot attached as a proof for the same.</th>
                            </tr>
                            <tr>
                                <th>13. As part of address verification using the postal method, Project91 Advance Technologies Pvt. Ltd. sends a letter to the candidate at the mentioned address and provides the proof of delivery as made available by the postal agencies.</th>
                            </tr>
                            <tr>
                                <th>14. Due to the limitations mentioned above, the results of the work performed by Project91 Advance Technologies Pvt. Ltd. with respect to background checks ought to be considered for internal purpose only. This report and remarks must not be viewed as a conclusive proclamation on the individual.</th>
                            </tr>
                            <tr>
                                <th>15. Project91 Advance Technologies Pvt. Ltd. expressly disclaim obligation or risk for any costs, harms, misfortunes, liabilities incurred by anybody because of distribution, generation or utilization of this report in contradiction to the limitations mentioned above.</th>
                            </tr>
                            <tr>
                                <th>16. The district and sessions court searched conducted cover all the subordinate courts as well – Civil Judge (junior division) and also the Judicial Magistrate courts.</th>
                            </tr>
                            <tr>
                                <th>17. For any further questions or clarifications, please email us at support@gettruehelp.com</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.4.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js"></script>
</body>
</html>