<!doctype html>
<html lang="en">

<head>
<!-- Required meta tags -->
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;900&display=swap" rel="stylesheet">
<style type="text/css">
@font-face {
    font-family: 'Roboto', sans-serif;
}
* { 
    font-family: 'Roboto', sans-serif;
    font-style: normal;
    font-weight: 400;
}
@page {
    size: 21cm 29.7cm;
    margin-top: 0cm;
    margin-bottom: 0cm;
    margin-left: 0cm;
    margin-right: 0cm;
    border: 1px solid blue;
}
body {
    background-color: #F3F6FC !important;
    position: relative;
    font-family: 'Roboto', sans-serif !important;
}

/********header-section***********/
.header-section{
    background-color: #0054FE;
}
.header-section p {
    color: #ffffff;
    padding: 0;
    margin: 0;
    font-weight: 100;
    float: right;
    margin-right: 70px;
}

.top-part {
    padding-right: 5%;
    padding-left: 5%;
}

.header-section .top-part{
    padding-top: 25px;        
    padding-bottom: 25px;
}

.header-section .top-part h4 {
    color: #FFFFFF;
    font-size: 28px;
    line-height: 25px;
    font-weight: bold;
}

.conditions h4 {
    color: #FFFFFF;
    font-size: 26px;
    font-weight: bold;
}

.header-section .top-part h6 {
    font-size: 23px;
    color: #fff;
}

.header-section .processing h4{
    color: #31DED2;
    font-size: 20px;
    font-weight: 700;
    margin-top: 17px;
    margin-bottom: -45px;
}
/********header-section ends****/


/****verification-details*****/
.Terms-Cons{
    background-color: #1b62fe;
    padding: 20px;
}
.Terms-Cons .conditions {
    margin-top: 20px;
    background: transparent;
    margin-bottom: 0px;
}
.Terms-Cons .conditions h1 {
    color: #FFFFFF;
    font-size: 33px;
    font-weight: 500;
}
.Terms-Cons .conditions span{
    color: #fff;
    font-size: 13px;
}
/*extra laptop/desktop */
 @media (max-width: 1199px){
    .header-section p {
    margin-right: 0px;
    font-size: 13px;
}
}
/* medium device*/
 @media (max-width: 767px){
    .header-section .top-part h4 {
    font-size: 24px;
}
}

.basic-info {
    display: inline-block;
    border: none;
    background-color: white;
    padding-top: 10px;
    margin-bottom: 20px;
    width: 100%;
    border-radius: 15px;
    padding-bottom: 10px;
    box-shadow: 0 6px 22px 0 rgba(155, 170, 157, .5);
    margin-top: -125px;
    width: 90%;
    margin-left: 5%;
}

.anticents-info {
    border: none;
    background-color: white;
    padding-top: 10px;
    border-radius: 15px;
    padding-bottom: 10px;
    box-shadow: 0 6px 22px 0 rgba(155, 170, 157, .5);
    width: 90%;
    margin-left: 5%;
}

.status-info {
    border: none;
    background-color: white;
    padding-top: 10px;
    margin-bottom: 30px;
    border-radius: 15px;
    padding-bottom: 10px;
    box-shadow: 0 6px 22px 0 rgba(155, 170, 157, .5);
    width: 90%;
    margin-left: 5%;
}
 .conditions {
    clear: both;
    display: block;
    width: 90%;
    margin-left: 5%;
}
.conditions h3 {
    font-weight: bold;
    margin-bottom: 25px;
    font-size: 30px;
    color: #1b62fe;
}
h1#tab-h1 {
    text-align: left;
    padding-left: 25px;
    color: #0054FE;
    font-size: 20px;
    font-weight: 700;
    color: #0054FE;
    margin-top: 10px;
}

.anticents-info {
    margin-top: 35px;
}

.anticents-info h4 {
    text-align: left;
    padding-left: 40px;
    font-size: 16px;
    line-height: 19px;
    color: #000000;
    margin-bottom: 3px;
}
#h4 {
    font-weight: 700;
    font-size: 14px;
    line-height: 10px;
}

#p {
    font-size: 14px !important;
    font-weight: 400;
    line-height: 16px;
}

#h5 {
    font-weight: 700;
    font-size: 20px;
    line-height: 16px;
    color: #0054FE;
}
#h5-c {
    font-weight: 700;
    font-size: 17px;
    line-height: 16px;
    color: #0054FE;
}
.h5-d {
    font-weight: 700;
    font-size: 20px;
    line-height: 16px;
    color: #0054FE;
}
.anticents-info h5 {
    padding-left: 39px;
    color: #000;
    font-size: 16px;
    line-height: 18px;
    font-weight: 600;
    text-align: left;
    margin-top: 7px;
}
.step1 a {
    margin-top: 5px;
    margin-right: 36px;
    font-size: 12px;
    line-height: 14px;
    font-weight: 600;
    float: right;
}

.fa-angle-left {
    font-size: 60px !important;
    color: #fff;
    float: left;
    margin-top: 8px;
    font-weight: bold !important;
}
.top-description h5 {
    font-size: 27px;
}
.top-description {
    padding-left: 45px;
    padding-top: 15px;
}
.top-description p {
    color: #000;
    font-size: 17px;
    line-height: 18px;
    text-align: left;
    margin-bottom: 4px;
}
.row.report-details {
    padding: 20px 40px 9px 36px;
}
.report-details h5 {
    font-size: 20px;
    font-weight: 600;
}
.report-details p {
    color: rgba(169, 172, 190, 1);
    font-size: 17px;
    line-height: 18px;
    text-align: left;
    margin-bottom: 4px;
}
.status-info .row {
    padding: 17px 30px;
    padding-bottom: 10px;
}

.status-info p {
    color: #000;
    font-size: 17px;
    line-height: 20px;
    text-align: left;
    margin-bottom: -40px;
    padding-top: 30px;
}
.status-info h5 {
    font-size: 20px;
    font-weight: 600;
}
.rep-dtls h4 {
    font-size: 15px;
    font-weight: 600;
    color: red;
}
.antecedents-value {
    color: #6bc077;
}
.RED_CASE {
    color: red;
}
  .fa {
    display: inline;
    font-style: normal;
    font-variant: normal;
    font-weight: normal;
    font-size: 14px;
    line-height: 1;
    font-family: FontAwesome;
    font-size: inherit;
    text-rendering: auto;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  td {
    font-size: 13.5px;
  }
  .pagenum:before {
        content: counter(page);
}

ul li {
    margin-right: 10px;
    color: #fff;
    font-size: 18px;
    font-weight: 600;
    z-index: 99999999999999;
}
a {
    color: #fff;
    z-index: 9999999999;
    text-decoration: none;
}


.tc ul li {
    color: #000 !important;
    font-size: 11px !important;
    font-weight: 500 !important;
}

p {
    font-size: 14px !important;
    line-height: 16px !important;
}

.top-description p {
  font-size: 17px !important;
    line-height: 15px !important;  
}
    </style>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
    <title>Self Health Check</title>
</head>

<body>
    <!-------Top section------->
    <div class="header-section" style="height: 235px; width: 100%;">
        <div class="top-part">
            <div class="justify-content-center align-items-center">
                <div class="col-lg-8 col-sm-8 col-8" style="margin-top: -20px; width: 65%; float: left; padding-top: 50px;">
                    <h4>Self Health Check</h4>
                    <h6 style="margin-top: -5px;">Client: 
                        @if(!empty($employers->b2b_company_name))
                          {{ $employers->b2b_company_name }} 
                          @if(!empty($employers->b2b_brand_name))
                            -- {{ $employers->b2b_brand_name }}
                          @endif
                        @else
                          {{ $employers->first_name }} {{ $employers->middle_name }} {{ $employers->last_name }}
                        @endif
                    </h6>
                </div>
                <div class="col-lg-4 col-sm-4 col-4 text-right" style="width: 34%; float: right;">
                    <!-- <img src="{{ url('/reports/image/back.png') }}" class="img-fluid" style="float: left; width: 30px; margin-top: 20px;"> -->
                    <!--<img src="{{ url('/reports/image/LOGO.png') }}" class="img-fluid">-->
                </div>                    
            </div>
        </div>
    </div>
    <!------------Top section ends-------->

    <!--Basic Info -->
    <div class="basic-info" style="margin-top: -60px; height: 200px;">
        <div class="row">
            <div style="margin-top: 15px; border: 0px solid #585d5c29; border-radius: 20px; overflow: hidden; margin-left: 40px; width: 130px;">
                @if(isset($employees->photo_url))
                    <div style="height: 130px; width: 130px;overflow: hidden;border-radius: 50%;display: flex;justify-content: center;align-items: center;margin:0; padding: 0;">
                        <img src="{{ $employees->photo_url }}" style="width: 130px;" />
                    </div>
                @else
                    <img src="{{ url('/reports/image/PERSON.png') }}" alt="PERSON" class="" style="width: 130px;">
                @endif
            </div>
            <div class="top-description" style="margin-left: 180px;">
                <h5 style="font-weight: bold;">{{ $employees->first_name }} {{ $employees->middle_name }} {{ $employees->last_name }}</h5>
                <!-- <p>Father's Name : {{ $employees->co_name }}</p> -->
                <p>Date of Birth : {{ date('d M Y', strtotime($employees->dob)) }}</p>
                <p>Ref No : {{ $tasks->task_number }}</p>
                <p>Candidate Id : 
                    @if($employees->employee_code)
                      ({{ $employees->employee_code }})
                    @else
                      ({{ $employees->employee_custom_id }})
                    @endif
                </p>
                <p>Verification Date : {{ date('l, F, d Y', strtotime($verificationFields['antecedants_data']['verification_date'])) }}</p>
                <p>Verification Time : {{ $verificationFields['antecedants_data']['verification_time'] ?? '' }}</p>
            </div>
        </div>
    </div>

    <?php

        $severity = $verificationFields['antecedants_data']['severity'] ?? '';
        
        if($severity == 'GREEN'){
            $color = '#6cc077';
            $case = 'GREEN CASE';
        } elseif($severity == 'RED'){
            $color = '#FC1102';
            $case = 'RED CASE';
        } elseif($severity == 'INCONCLUSIVE'){
            $color = '#FCD302';
            $case = 'INCONCLUSIVE';
        } else {            
            $color = '#FCD302';
            $case = 'YELLOW CASE';
        }
    ?>

    <div class="status-info" style="margin-top: -35px; padding-top: 20px; padding-bottom: 10px; width: 90% !important;">
        <div class="row">
            <div class="col-9">
                <h5 id="h5">Self Health Check</h5>                
            </div>
            <div class="col-3 text-right rep-dtls" style="float: right;">
                <h4 id="h5-c" style="color: {{ $color }};">{{ $case }}</h4>
            </div>
            <div class="col-12">
                <p>{{ $verificationFields['antecedants_data']['conclusion'] ?? '' }}</p>
            </div>
        </div>
    </div>

    <div class="anticents-info" style="margin-top: -15px; margin-bottom: 20px;">
        <div class="row">
            <div class="col-12">
                <h1 id="tab-h1">Verification Details</h1>
            </div>
            <div class="col-12" style="padding-top: 50px; padding-bottom: -40px;">

                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">{{ $verificationFields['antecedants_data']['current_temprature']['name'] ?? '' }}</h4>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['current_temprature']['value'] ?? '' }}</h5>
                </div>

                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">Have you been diagnosed with or had symptoms of COVID-19 in the past 14 days? COVID-19 symptoms include: cough, difficulty breathing or shortness of breath, fever or chills, new loss of taste or smell, muscle or body aches, fatigue, headache, sore throat, congestion or runny nose, nausea, vomiting, or diarrhea.</h4>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['had_symptoms'] ?? '' }}</h5>
                </div>

                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">Have you tested positive for COVID-19 within the past 14 days?</h4>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['tested_positive'] ?? '' }}</h5>
                </div>

                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">Have you tested positive for COVID-19 within the past 14 days?</h4>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['proximate_contact'] ?? '' }}</h5>
                </div>

                <div style="width: 97%; padding-left: -15px !important; margin-bottom: 10px;">
                    <h4 id="h4" style="margin-bottom: -3px; font-size: 15px;">I confirm the answer to all the above questions is “YES/NO” for me on this date.</h4>
                    <h5 id="p">{{ $verificationFields['antecedants_data']['confirm_answer'] ?? '' }}</h5>
                </div>

            </div>
        </div>
    </div>

    @include('templates.pagefooter')

    <div style="clear: both;"></div>

    <!-------Top section------->
    <div class="header-section" style="height: 215px; width: 100%; margin-top: 80px;">
        <div class="top-part">
            <div class="justify-content-center align-items-center">
                <div class="col-lg-6 col-sm-6 col-6" style="margin-top: -20px; width: 50%; float: left; padding-top: 50px;">
                    <h4 style="color: #fff;">
                        Terms & Conditions
                    </h4>
                </div>
                <div class="col-lg-6 col-sm-6 col-6 text-right" style="width: 49%; float: right;">
                    <!--<img src="{{ url('/reports/image/LOGO.png') }}" class="img-fluid">-->
                </div>                    
            </div>
        </div>
    </div>
    <!------------Top section ends-------->
    <!---------terms and conditions------>
    <style type="text/css">
        ul li {
            font-size: 13px;
            list-style: none;
            margin-left: -15px;
        }
        ol li {
            font-size: 13px;
            list-style: none;
            margin-left: -15px;
            line-height: 14.5px;
            padding-bottom: 5px;
            padding-right: 5px;
        }
    </style>
    <div class="basic-info tc" style="position: absolute; bottom: 70px;">
        <ol style="padding-bottom: -20px;">
            <li>1. This verification document is a computer generated document and does not require a digital signature</li>
            <li>2. The information in this report may only2be used by the client to verify statements made by an individual for purposes such as pre-employment verification, suitability for an alliance, etc. This report isn’t a substitute to any process required by the authorities and is not expected to disregard any law that must be adhered to.</li>
            <li>3. IVRFI Is not the source of the data gathered and the reports are based on the information made available through various modes as verbal, databases, written or Internet and so forth. Therefore, IVRFI Cannot ensure the accuracy of the data gathered. The data contained in this report is given “as is” with no guarantees, although each effort is made to guarantee that the report is exact and up to date.</li>
            <li>4. Final verification of an individual’s identity and proper use of this verification report is responsibility fo the client.</li>
            <li>5. It is the client’s responsibility to use the verification reports in a fair manner.</li>
            <li>6. IVRFI intends to help the client get more transparency into the individual’s identity, antecedents and character based on it’s verification report. However, Ivrfai. is not responsible for employment decisions made by the client based on the information presented in this verification report.</li>
            <li>7. Under relevant statutory frameworks including the IT Act 2000, client is advised secure storage of this report to protect the privacy of the individual and destruction of the report as per the client’s internal policy of document maintenance.</li>
            <li>8. IVRFI conducts criminal court records check through reliable government portal for on-going case details and judgements in all District courts of India.</li>
            <li>9. Based on subscription opted by the customer, the search scope is determined. For ex: if the subscription is for PAN India district courts search, then all the district courts in India are searched and if the subscription is only for a specific state search, then all the courts for the corresponding state based on the address provided are searched.</li>
            <li>10. The display of names of the courts in the report Annexure for the court record search results is restricted to display only the names of the courts that correspond to the district of the provided addresses irrespective of the search scope. This is done to keep the report usable and restrict the number of pages in the report.</li>
            <li>11. IVRFI  is registered with NSDL for online PAN verification. Since the results come via system integration, the screenshot proofs might not be always available.</li>
            <li>12. IVRFI  is a registered Sub-AUA with UIDAI and the Aadhaar verification is done through system integration with the UIDAI database. Therefore, there would be no screenshot attached as a proof for the same.</li>
            <li>13. As part of address verification using the postal method, IVRFI  sends a letter to the candidate at the mentioned address and provides the proof of delivery as made available by the postal agencies.</li>
            <li>14. Due to the limitations mentioned above, the results of the work performed by Ivrfi with respect to background checks ought to be considered for internal purpose only. This report and remarks must not be viewed as a conclusive proclamation on the individual.</li>
            <li>15. IVRFI  expressly disclaim obligation or risk for any costs, harms, misfortunes, liabilities incurred by anybody because of distribution, generation or utilization of this report in contradiction to the limitations mentioned above.</li>
            <li>16. The district and sessions court searched conducted cover all the subordinate courts as well – Civil Judge (junior division) and also the Judicial Magistrate courts.</li>
            <li>17. For any further questions or clarifications, please email us at support@ivrfi.com</li>
    </div>

    @include('templates.pagefooter')

</body>
</html>