<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;900&display=swap" rel="stylesheet">
    <style type="text/css">
    @font-face {
        font-family: 'Roboto', sans-serif;
    }
    * { 
        font-family: 'Roboto', sans-serif;
        font-style: normal;
        font-weight: 400;
    }
    @page {
        size: 21cm 29.7cm;
        margin-top: 0cm;
        margin-bottom: 0cm;
        margin-left: 0cm;
        margin-right: 0cm;
        border: 1px solid blue;
    }
    body {
        background-color: #F3F6FC !important;
        position: relative;
        font-family: 'Roboto', sans-serif !important;
    }
    /********header-section***********/
    .header-section{
        background-color: #0054FE;
    }
    .basic-info {
        display: inline-block;
        border: none;
        background-color: white;
        padding-top: 10px;
        margin-bottom: 20px;
        width: 100%;
        padding-bottom: 10px;
        box-shadow: 0 6px 22px 0 rgba(155, 170, 157, .5);
        width: 95%;
        margin-left: 2.5%;
    }
    .top-description {
        padding-left: 45px;
        padding-top: 12px;
    }
    .borderd-table table, .borderd-table th, .borderd-table td {
        border: 1px solid #0054FE;
        border-collapse: collapse;
    }
    .Terms-Cons{
        background-color: #1b62fe;
        padding: 20px;
    }
    .Terms-Cons .conditions {
        margin-top: 20px;
        background: transparent;
        margin-bottom: 0px;
    }
    .Terms-Cons .conditions h1 {
        color: #FFFFFF;
        font-size: 33px;
        font-weight: 500;
    }
    .Terms-Cons .conditions span{
        color: #fff;
        font-size: 13px;
    }
    .pagenum:before {
        content: counter(page);
    }
    </style>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
    <title>LYNX3SIXTY | AADHAR VERIFICATION REPORT</title>
</head>

<body>
    <section class="header-section" style="height: 90px; width: 100%; padding-bottom: -20px;">
        <div style="width: 80px; float: left; padding-left: 40px; padding-top: 25px;">
            <img src="{{ url('/reports/image/shield.png') }}" class="img-fluid" style="width: 50px; height: 50px;">
        </div>
        <div style="width: 650px; float: right; padding-top: 22px;">
            <h5 style="color: #fff;">AADHAR VERIFICATION REPORT</h5>
        </div>
    </section>

    <!--Basic Info -->
    <div class="basic-info" style="margin-top: 30px; height: 120px;">
        <div class="row">
            <div style="overflow: hidden; margin-left: 25px; width: 130px; height: 150px">
                @if(isset($employees->photo_url))
                    <div style="height: 120px; width: 120px; overflow: hidden;border-radius: 50%;display: flex;justify-content: center;align-items: center;margin:0; padding: 0;">
                        <img src="{{ $employees->photo_url }}" style="width: 120px; height: 120px;" />
                    </div>
                @else
                    <img src="{{ url('/reports/image/PERSON.png') }}" alt="PERSON" class="" style="width: 120px; height: 135px">
                @endif
            </div>
            <div class="top-description" style="margin-left: 110px; float: left; width: 100%;">
                <table class="borderd-table" width="96%" style="margin-top: -23px;">
                    <tr>
                        <td colspan="2" style="line-height: 24px; padding: 8px; padding-bottom: 0px;"><b>Organization Name</b> : 
                            @if(!empty($employers->b2b_company_name))
                              {{ $employers->b2b_company_name }} 
                              @if(!empty($employers->b2b_brand_name))
                                ({{ $employers->b2b_brand_name }})
                              @endif
                            @else
                              {{ $employers->first_name }} {{ $employers->middle_name }} {{ $employers->last_name }}
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <td style="line-height: 24px; padding: 8px; padding-bottom: 0px;"><b>Name</b> : {{ $employees->first_name }} {{ $employees->middle_name }} {{ $employees->last_name }}</td>
                        <td style="line-height: 24px; padding: 8px; padding-bottom: 0px;"><b>Ref No </b> : {{ $tasks->task_number }}</td>
                    </tr>
                    <tr>
                        <td style="line-height: 24px; padding: 8px; padding-bottom: 0px;"><b>Location</b> : {{ $verificationFields['antecedants_data']['state']['value'] ?? '' }}</td>
                        <td style="line-height: 24px; padding: 8px; padding-bottom: 0px;"><b>Report Date</b> : {{ date('d M Y') }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <br />
    <div class="basic-info" style="margin-top: -10px; height: 46px;">
        <div class="row">
            <table width="97%" style="margin-left: 25px; border: none;">
                <tr>
                    <td style="padding-bottom: 0px; border: none; line-height: 12px; padding-top: 10px;">
                        <button type="button" class="btn btn-info" style="background-color: #008000; width: 40px; height: 18px;"></button>
                    </td>
                    <td style="padding-bottom: 0px; border: none; line-height: 12px;">
                        Clear/Verified
                    </td>
                    <td style="padding-bottom: 0px; border: none; line-height: 12px; padding-top: 10px;">
                        <button type="button" class="btn btn-info" style="background-color: #C70039; width: 40px; height: 18px;"></button>
                    </td>
                    <td style="padding-bottom: 0px; border: none; line-height: 12px;">
                        Major Discrepancy
                    </td>
                    <td style="padding-bottom: 0px; border: none; line-height: 12px; padding-top: 10px;">
                        <button type="button" class="btn btn-info" style="background-color: #FFBF00; width: 40px; height: 18px;"></button>
                    </td>
                    <td style="padding-bottom: 0px; border: none; line-height: 12px;">
                        Minor Discrepancy
                    </td>
                    <td style="padding-bottom: 0px; border: none; line-height: 12px; padding-top: 10px;">
                        <button type="button" class="btn btn-info" style="background-color: #0096FF; width: 40px; height: 18px;"></button>
                    </td>
                    <td style="padding-bottom: 0px; border: none; line-height: 12px;">
                        Insufficiency/UTV
                    </td>
                </tr>
            </table>
        </div>
    </div>
    
    <?php

        $severity = $verificationFields['antecedants_data']['severity'] ?? '';
        
        if($severity == 'GREEN'){
            $color = '#008000';
            $case = 'Clear/Verified';
        } elseif($severity == 'RED'){
            $color = '#C70039';
            $case = 'Major Discrepancy';
        } else {            
            $color = '#FFBF00';
            $case = 'Minor Discrepancy';
        }
    ?>
    
    <h5 style="width:100%; margin-left: 25px; margin-top: 10px;">Verification Summary</h5>
    <div class="basic-info" style="margin-top: 21px; height: auto; display: block; overflow: hidden;">
        <div class="row">
            <table class="borderd-table" width="96%" style="margin-top: 0px; margin-left: 25px;">
                <tr>
                    <th style="padding-left: 8px;">Aadhar Number</th>
                    <th style="padding-left: 8px;">
                        @php
                            $a_num = $verificationFields['antecedants_data']['aadhar_number']['value'] ?? '';    
                        @endphp
                        {{ 'XXXX-XXXX-XXXX-'.substr($a_num,-4)}}
                    </th>
                    <th style="padding-left: 8px;">
                        <div style="margin: 0 auto; padding: 0px; width: 100%; margin-top: -4px;">
                            <button type="button" style="background-color: 
                            @if($verificationFields['antecedants_data']['aadhar_number']['match_status'] == 'MATCHED')
                                #008000;
                            @elseif($verificationFields['antecedants_data']['aadhar_number']['match_status'] == 'PARTIAL_MATCHED')
                                #C70039;
                            @else
                                #FFBF00;
                            @endif
                            width: 10px; height: 10px; border-radius: 50%; margin-top: 2px;"></button> 
                            @if($verificationFields['antecedants_data']['aadhar_number']['match_status'] == 'MATCHED')
                                Clear/Verified
                            @elseif($verificationFields['antecedants_data']['aadhar_number']['match_status'] == 'PARTIAL_MATCHED')
                                Major Discrepancy
                            @else
                                Minor Discrepancy
                            @endif
                        </div>
                    </th>
                </tr>
                <tr>
                    <th style="padding-left: 8px;">Age Band</th>
                    <th style="padding-left: 8px;">
                        {{ $verificationFields['antecedants_data']['age_band']['value'] ?? '' }}
                    </th>
                    <th style="padding-left: 8px;">
                        <div style="margin: 0 auto; padding: 0px; width: 100%; margin-top: -4px;">
                            <button type="button" style="background-color: 
                            @if($verificationFields['antecedants_data']['age_band']['match_status'] == 'MATCHED')
                                #008000;
                            @elseif($verificationFields['antecedants_data']['age_band']['match_status'] == 'PARTIAL_MATCHED')
                                #C70039;
                            @else
                                #FFBF00;
                            @endif
                            width: 10px; height: 10px; border-radius: 50%; margin-top: 2px;"></button> 
                            @if($verificationFields['antecedants_data']['age_band']['match_status'] == 'MATCHED')
                                Clear/Verified
                            @elseif($verificationFields['antecedants_data']['age_band']['match_status'] == 'PARTIAL_MATCHED')
                                Major Discrepancy
                            @else
                                Minor Discrepancy
                            @endif
                        </div>
                    </th>
                </tr>
                <tr>
                    <th style="padding-left: 8px;">Gender</th>
                    <th style="padding-left: 8px;">
                        {{ $verificationFields['antecedants_data']['gender']['value'] ?? '' }}
                    </th>
                    <th style="padding-left: 8px;">
                        <div style="margin: 0 auto; padding: 0px; width: 100%; margin-top: -4px;">
                            <button type="button" style="background-color: 
                            @if($verificationFields['antecedants_data']['gender']['match_status'] == 'MATCHED')
                                #008000;
                            @elseif($verificationFields['antecedants_data']['gender']['match_status'] == 'PARTIAL_MATCHED')
                                #C70039;
                            @else
                                #FFBF00;
                            @endif
                            width: 10px; height: 10px; border-radius: 50%; margin-top: 2px;"></button> 
                            @if($verificationFields['antecedants_data']['gender']['match_status'] == 'MATCHED')
                                Clear/Verified
                            @elseif($verificationFields['antecedants_data']['gender']['match_status'] == 'PARTIAL_MATCHED')
                                Major Discrepancy
                            @else
                                Minor Discrepancy
                            @endif
                        </div>
                    </th>
                </tr>
                <tr>
                    <th style="padding-left: 8px;">State</th>
                    <th style="padding-left: 8px;">
                        {{ $verificationFields['antecedants_data']['state']['value'] ?? '' }}
                    </th>
                    <th style="padding-left: 8px;">
                        <div style="margin: 0 auto; padding: 0px; width: 100%; margin-top: -4px;">
                            <button type="button" style="background-color: 
                                @if($verificationFields['antecedants_data']['state']['match_status'] == 'MATCHED')
                                    #008000;
                                @elseif($verificationFields['antecedants_data']['state']['match_status'] == 'PARTIAL_MATCHED')
                                    #C70039;
                                @else
                                    #FFBF00;
                                @endif
                            width: 10px; height: 10px; border-radius: 50%; margin-top: 2px;"></button> 
                            @if($verificationFields['antecedants_data']['state']['match_status'] == 'MATCHED')
                                Clear/Verified
                            @elseif($verificationFields['antecedants_data']['state']['match_status'] == 'PARTIAL_MATCHED')
                                Major Discrepancy
                            @else
                                Minor Discrepancy
                            @endif
                        </div>
                    </th>
                </tr>
            </table>
        </div>
    </div>
    <h5 style="width:100%; margin-left: 25px; margin-top: 10px;">Conclusion</h5>
    <p style="width:100%; margin-left: 25px; margin-top: 10px; line-height: 14px;">{{ $verificationFields['antecedants_data']['conclusion'] ?? '' }}</p>
    <h5 style="width:100%; margin-left: 25px; margin-top: 10px;">Attachments</h5>
    <div class="basic-info" style="margin-top: 21px; height: auto; display: block; overflow: hidden;">
        <div class="row">
            <table class="borderd-table" width="96%" style="margin-top: 0px; margin-left: 25px;">
                <tr>
                    <td>
                        <img src="{{ url('screenshot-1.png') }}" style="width: 730px; height: 300px;">
                    </td>
                </tr>
            </table>
        </div>
    </div>
    @include('templates.pagefooter')
</body>
</html>